import svelte from 'rollup-plugin-svelte';
import commonjs from '@rollup/plugin-commonjs';
import resolve from '@rollup/plugin-node-resolve';
import livereload from 'rollup-plugin-livereload';
import { terser } from 'rollup-plugin-terser';
import css from 'rollup-plugin-css-only';
import sveltePreprocess from 'svelte-preprocess';


const production = !process.env.ROLLUP_WATCH;

export default {
	input: {
	'js/main': 'assets/source/main.js'
	},
	output: {
		sourcemap: true,
		format: 'iife',
		name: 'aaardvark',
		dir: 'assets/'
	},
	plugins: [
		svelte({
			preprocess: sveltePreprocess({
				sourceMap: !production,
				postcss: {
					plugins: [require('tailwindcss'), require('autoprefixer')]
				}
			}),
			compilerOptions: {
				dev: !production
			}
		}),
		css({ output: 'css/bundle.css' }),
		resolve({
			browser: true,
			dedupe: ['svelte']
		}),
		commonjs(),
		!production && livereload('public'),
		production && terser()
	],
	watch: {
		clearScreen: false
	}
};
