<?php
/**
 *
 * @see              https://aaardvarkaccessibility.com
 * @since             1.0.0
 *
 * @package AAArdvark
 *
 * @wordpress-plugin
 * Plugin Name:       AAArdvark
 * Plugin URI:        https://aaardvarkaccessibility.com
 * Description:       Connect WordPress to the AAArdvark accessibility testing service to display statistics and reports.
 * Version:           1.0.5
 * Author:      			AAArdvark
 * Author URI:  			https://aaardvarkaccessibility.com
 * License:           GPLv2 or later.
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       aaardvark
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	exit;
}

/*
 * Currently plugin version.
 */
define( 'AAARDVARK_VERSION', '1.0.5' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-aaardvark-activator.php.
 */
function activate_aaardvark() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aaardvark-activator.php';
	AAArdvark_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-aaardvark-deactivator.php.
 */
function deactivate_aaardvark() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aaardvark-deactivator.php';
	AAArdvark_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_aaardvark' );
register_deactivation_hook( __FILE__, 'deactivate_aaardvark' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-aaardvark.php';

/**
 * This plugin's url.
 *
 * @since  0.0.0
 *
 * @param  string $path (optional) appended path.
 * @return string       URL and path.
 */
function aaardvark_plugin_url( $path = '' ) {
	static $url;
	$url = $url ? $url : trailingslashit( plugin_dir_url( __FILE__ ) );
	
	return $url . $path;
}

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_aaardvark() {
	$plugin = new AAArdvark();
	$plugin->run();
}
run_aaardvark();
